@extends('template')
@section('head')
<script src="{{root('js/top.js')}}"></script>
<script src="{{asset('js/buy/_system.js')}}"></script>
<script src="{{asset('js/buy/system.js')}}"></script>
<script src="{{asset('js/buy/map.js')}}"></script>
<link rel="stylesheet" href="{{ root('css/index_map.css')}}">
@endsection

@section('content')


<div class="top">
    <div class="wrapper">

        <div class="top__main-visual">
            <img class="pc" src="{{root('img/top/top.jpg')}}" alt="">
            <img class="sp" src="{{root('img/top/top-sp.jpg')}}" alt="">
            <div class="top__main-text">
            <img src="{{root('img/top/top_family.png')}}" alt="">
            <h1>横浜市の不動産のことなら<br />三春情報センターへ</h1>
            <strong>アフターサービスではなく一生涯のサービスを。</strong>
            <span>Service for your lifetime</span>
            </div>
        </div>
        <div class="title">
            <h2 class="title__title">INFOMATION</h2>
        </div>

        <div class="top__lists">
            <div class="list">
                <div class="list__title">オープンハウス情報<a href="openhouse">一覧<i class="fas fa-chevron-right"></i></a></div>
                <div class="list__box">
                @for ($i = 0; $i < 3; $i++)
                <a hre="buy"><dl class="list__dloh">
                    <dt class="list__dtoh"><img src="{{root('img/top/list1.jpg')}}" alt=""></dt>
                    <dd class="list__ddoh">
                        <div class="list__date"><span class="recommend__tag">マンション</span>2019.00.00</div>
                        <p class="list__text">「リストレジデンス横濱洋光台」オープンハウス</p>
                        <p class="list__text">期間：7月22日(土)～23日(日)<br />
                          時間：11:00～17:00<br />
                          場所：神奈川県横浜市港南区日野中央３</p>
                    </dd>
                  </dl></a>
                    @endfor
                    </div>
            </div>
            <div class="list">
                <div class="list__title">トピックス<a href="topics">一覧<i class="fas fa-chevron-right"></i></a></div>
                <div class="list__box">
                <dl class="list__dl">
                    <dt class="list__dt">
                      <span class="list__new">NEW</span>
                      <span class="list__dt-tag1">イベント</span>2019.0.0</dt>
                    <dd class="list__dd">
                        <a href="topics">本日より、ウェブサイトをリニューアルいたしました。<br> ウェブサイトをリニューアルいたしました。</a>
                    </dd>
                    </dl>



                <dl class="list__dl">
                        <dt class="list__dt">
                          <span class="list__new">NEW</span>
                          <span class="list__dt-tag4">セミナー</span>2019.0.0</dt>
                        <dd class="list__dd">
                            <a href="topics">本日より、ウェブサイトをリニューアルいたしました。<br> ウェブサイトをリニューアルいたしました。</a>
                        </dd>
                    </dl>

                <dl class="list__dl">
                    <dt class="list__dt"><span class="list__dt-tag3">そのほか</span>2019.0.0</dt>
                    <dd class="list__dd">
                        <a href="topics">本日より、ウェブサイトをリニューアルいたしました。<br> ウェブサイトをリニューアルいたしました。</a>
                    </dd>
                    </dl>
                <dl class="list__dl">
                    <dt class="list__dt"><span class="list__dt-tag2">お知らせ</span>2019.0.0</dt>
                    <dd class="list__dd">
                        <a href="topics">本日より、ウェブサイトをリニューアルいたしました。<br> ウェブサイトをリニューアルいたしました。</a>
                    </dd>
                    </dl>
                <dl class="list__dl">
                    <dt class="list__dt"><span class="list__dt-tag1">イベント</span>2019.0.0</dt>
                    <dd class="list__dd">
                        <a href="topics">本日より、ウェブサイトをリニューアルいたしました。<br> ウェブサイトをリニューアルいたしました。</a>
                    </dd>
                    </dl>
                    </div>
            </div>
        </div>
    </div>
</div>

<div class="map">
    <div class="map__tab-wrap">
        <div class="map__tab"><i class="fas fa-search"></i>物件を探す</div>
        <span>ご希望の区名・物件種別を一つお選びください。</span>
    </div>
	<script type="text/javascript">
		function map_hover_group(id){
			//console.log("hover group : " + id);
			MAP.over(id);
			if (id != 0){
				$('.town-link' + id).css('text-decoration', 'underline');
			}
			else {
				$('.town-link').css('text-decoration', 'none');
			}
		}

		function map_hover_item(id){
			MAP.over(id);
			if(id == 0) {
				$('.town-link').css('text-decoration', 'none');
			}
			else {
				$('.town-link-'+ id).css('text-decoration', 'none');
			}
		}
		</script>
    <div class="map-search">
    <div class="map-search__left">
		<div id="MAP" class="MAP">
			<div class="MAP_BOX">
				<map name="IMGMAP" id="IMGMAP">
				<img src="{{root('img/buy/map_top.png')}}" alt="">
				<area href="" alt="南区" onmouseover="MAP.over(14105);" onmouseout="MAP.over(0);" shape="poly"coords="163,101 190,121 228,114 251,144 264,98 310,91 299,42 211,47 171,69" />
				<area href="" alt="磯子区" onmouseover="MAP.over(14107);" onmouseout="MAP.over(0);" shape="poly" coords="211,206 216,277 212,296 322,201 347,125 310,91 246,98 251,144 257,158 219,166 250,200" />
				<area href="" alt="金沢区" onmouseover="MAP.over(14108);" onmouseout="MAP.over(0);" shape="poly" coords="212,296 260,420 388,323 376,190 322,201" />
				<area href="" alt="港南区" onmouseover="MAP.over(14111);" onmouseout="MAP.over(0);" shape="poly" coords="118,214 216,277 211,206 250,200 219,166 257,158 251,144 228,144 190,121 163,101 119,116" />
				<area href="" alt="栄区" onmouseover="MAP.over(14115);" onmouseout="MAP.over(0);"	shape="poly" coords="22,271 201,356 212,296 216,277 135,246 118,214 63,209" />
				</map>
				<img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="MOUSE OVER ACTION" usemap="#IMGMAP" />
				<img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
				<img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
				<img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
				<img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
				<img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />

			</div>
		</div>
	</div>
    <div class="map-search__right">
		<div class="town town-14111" >
        <dl class="town-name">
          <dt><img src="{{root('img/buy/mapicon-konan.png')}}" alt=""></dt>
          <dd>
          <a href="minato/" class="town-link town-link-14111" onmouseover="map_hover_group(14111);" onmouseout="map_hover_group(0);"><em>横浜市港南区の<br />不動産（00）</em></a>
          </dd>
        </dl>
        <div class="town-bukken">
         <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
          <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
        </div>
      </div><!--town-->

      <div class="town town-14105">
        <dl class="town-name ">
          <dt><img src="{{root('img/buy/mapicon-minami.png')}}" alt=""></dt>
          <dd>
          <a href="minato/" class="town-link town-link-14105" onmouseover="map_hover_group(14105);" onmouseout="map_hover_group(0);"><em>横浜市南区の<br />不動産（00）</em></a>
          </dd>
        </dl>
        <div class="town-bukken">
         <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
          <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
        </div>
      </div><!--town-->

      <div class="town  town-14107" >
        <dl class="town-name">
          <dt><img src="{{root('img/buy/mapicon-isogo.png')}}" alt=""></dt>
          <dd>
          <a href="" class="town-link town-link-14107" onmouseover="map_hover_group(14107);" onmouseout="map_hover_group(0);"><em>横浜市磯子区の<br />不動産（00）</em></a>
          </dd>
        </dl>
        <div class="town-bukken">
         <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
          <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
        </div>
      </div><!--town-->

      <div class="town  town-14108" >
        <dl class="town-name">
          <dt><img src="{{root('img/buy/mapicon-kanazawa.png')}}" alt=""></dt>
          <dd><a href="" class="town-link town-link-14108" onmouseover="map_hover_group(14108);" onmouseout="map_hover_group(0);"><em>横浜市金沢区の<br />不動産（00）</em></a>
          </dd>
        </dl>
        <div class="town-bukken">
         <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
          <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
        </div>
      </div><!--town-->

       <div class="town town-14115" >
        <dl class="town-name">
          <dt><img src="{{root('img/buy/mapicon-sakae.png')}}" alt=""></dt>
          <dd><a href="" class="town-link town-link-14115" onmouseover="map_hover_group(14115);" onmouseout="map_hover_group(0);"><em>横浜市栄区の<br />不動産（00）</em></a>
          </dd>
        </dl>
        <div class="town-bukken">
         <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
          <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
          <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
        </div>
      </div><!--town-->
    </div><!--map-search__right-->
  </div>

  <div class="key">
    <span><img src="{{root('img/buy/icon_search_white.png')}}" alt="">物件名・マンション名・住所のキーワードから探す</span>
    <form action="bukkenlist.php" name="FMfrm" method="get" onsubmit="return cbCheck();">
      <input class="INPUT" type="text" name="key" value="キーワードを入力してください" onfocus="if(this.value == this.defaultValue) { this.value = ''; }" onblur="if(this.value == '') { this.value = this.defaultValue; }" />
      <input class="SUBMIT" type="submit" value="検　索"  />
    </form>
  </div><!--KEY-->

</div><!--map-->



<div class="service">
    <div class="wrapper">
        <div class="title">
            <h2 class="title__title">SERVICE</h2>
            <div class="title__top">
                <h3 class="title__headline">すべては、お客様の「真の幸せ」を<br class="sp">実現するために</h3>
                <p>不動産という枠にとらわれず、お客様のすべてのニーズにお応えできるようなサービスを展開します。</p>
            </div>
        </div>
        <div class="service__column">
            <div class="service__image">
                <img src="{{root('img/top/column1.jpg')}}" alt="">
            </div>
            <div class="service__text">
                <i class="fas fa-caret-right"></i>
                <div class="service__wrapper">
                    <div class="service__number">01</div>
                    <div class="service__mini-title">
                        住まいを探す
                    </div>
                    <div class="service__mini-text">
                        横浜市港南区、南区、磯子区、金沢区、栄区、鎌倉 市を中心とした不動産情報。リフォーム、注文住宅の相談もワンストップでご対応いたします。
                    </div>
                    <a href="buy/" class="service__button">
                        詳細を見る
                    </a>
                </div>
            </div>
        </div>

        <div class="service__column">
            <div class="service__image">
                <img src="{{root('img/top/column2.jpg')}}" alt="">
            </div>
            <div class="service__text">
                <i class="fas fa-caret-right"></i>
                <div class="service__wrapper">
                    <div class="service__number">02</div>
                    <div class="service__mini-title">
                        住まいを売る
                    </div>
                    <div class="service__mini-text">
                        わたしたち三春情報センターは地元の横浜・横須賀・湘南エリアで常時活発な販売活動を行っています。お客様のご要望に叶うご提案で、不動産売却を全力でお手伝いします。 </div>
                    <a href="sell/" class="service__button">
                        詳細を見る
                    </a>
                </div>
            </div>
        </div>

        <div class="service__column">
            <div class="service__image">
                <img src="{{root('img/top/column3.jpg')}}" alt="">
            </div>
            <div class="service__text">
                <i class="fas fa-caret-right"></i>
                <div class="service__wrapper">
                    <div class="service__number">03</div>
                    <div class="service__mini-title">
                        中古＋リフォーム
                    </div>
                    <div class="service__mini-text">
                        購入がしやすい中古マンションや一戸建て物件を、家族の夢を叶える、細部まで丁寧につくりこまれた“オーダーメイド住空間”へ造り替えます。 </div>
                    <a href="reform/" class="service__button">
                        詳細を見る
                    </a>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="recommend">
    <div class="wrapper">
        <div class="title">
            <h2 class="title__title">RECOMMEND</h2>
            <div class="title__top">
                <h3 class="title__headline">三春情報センターのおすすめ物件</h3>
                <p>三春情報センターのおすすめ物件をご紹介いたします。クリックで詳細をご覧いただけます。</p>
            </div>
        </div>

        <div class="recommend__list">
            @for ($i = 0; $i
            < 6; $i++) <a class="recommend__component" href="">
                <figure><img src="{{root('img/top/bukken.jpg')}}" alt=""><figcaption><i class="fas fa-chevron-right"></i></figcaption></figure>
                <div class="recommend__info">
                    <div class="recommend__top">
                        <div class="recommend__date">
                            2019.0.0
                        </div>
                        <div class="recommend__tag">
                            マンション
                        </div>
                    </div>
                    <div class="recommend__name">
                        物件名
                    </div>
                    <dl class="recommend__detail">
                        <dt class="recommend__detail-pricedt"><i class="fas fa-yen-sign"></i></dt>
                        <dd class="recommend__detail-pricedd"><strong>0,000</strong>万円</dd>
                    </dl>
                    <dl class="recommend__detail">
                        <dt><i class="fas fa-map-marker-alt"></i></dt>
                        <dd>あたりあたり</dd>
                    </dl>
                    <dl class="recommend__detail">
                        <dt><i class="fas fa-subway"></i></dt>
                        <dd>あたりあたり</dd>
                    </dl>
                    <div class="recommend__view">
                        詳細をみる<i class="fas fa-chevron-right"></i>
                    </div>

                </div>
                </a>
                @endfor

                <a href="buy/bukkenlist" class="recommend-overviews__link">
                おすすめ物件一覧を見る<i class="fas fa-chevron-right"></i>
                </a>
        </div>
    </div>
</div>

<div class="reason">
    <div class="wrapper">
      <div class="title">
          <h2 class="title__title">MERIT</h2>
          <div class="title__top">
              <h3 class="title__headline">三春情報センターが喜ばれる理由</h3>
              <p>わたしたち三春情報センターはお客様の真の幸せを実現することを使命としています。</p>
          </div>
      </div>

        <div class="reason__contents">
          <dl>
            <dt><strong>1<br /><span>総合生活産業</span></strong><span class="num_sp">01</span></dt>
            <dd><span class="sp">総合生活産業</span>お客様の生活シーンにおけるさまざまな幸せをサポートするための総合的なサービスの構築を続けます。</dd>
          </dl>

          <dl>
            <dt><strong>2<br /><span>地域土着</span></strong><span class="num_sp">02</span</dt>
            <dd><span class="sp">地域土着</span>昭和52年横浜市栄区で創業。これからもこの地の「住まいと暮らしの第一人者」としてあり続けます。</dd>
          </dl>

          <dl>
            <dt><strong>3<br /><span>暮らしにあった<br />住まい方のご提案</span></strong><span class="num_sp">03</span</dt>
            <dd><span class="sp">暮らしにあった住まい方のご提案</span>一つひとつの「暮らし」にあった住まいを、お客様とともにつくりあげます。</dd>
          </dl>

          <dl style="border-bottom:0;">
            <dt><strong>4<br /><span>親子３代の<br />お付き合い</span></strong><span class="num_sp">04</span</dt>
            <dd><span class="sp">親子３代のお付き合い</span>アフターサービスではなく、一生涯のサービス提案。お子様、お孫様の代までお付き合いいたします。</dd>
          </dl>
        </div>
      <img class="reason__illust"src="{{root('img/top/reason_illust.png')}}" alt="三春情報センターが喜ばれる理由">
    </div>
</div>

<style type="text/css">
 .title__title::after {
	background-color: #333333;
 }
 @media screen and (max-width: 768px) and (max-device-width: 1024px) {
	.wrapper {
		width: auto;
	}
	.top__main-visual {
		width: 100%;
	}
	.top__main-visual img {
		width: 100%;
	}
	.header__link-wrapper .header__link {
		margin: 0 25px 0 0;
	}

	.inner {
		width: auto;
	}

	
	
	.top__lists {
		width: 100%
	}
	.map-search__left {
		display: none;
	}
	.map-search {
		width: auto;
	}
	
	.key {
		width:auto;
	}
	.reason__contents {
		width: auto;
		margin-left: 10px;
	}
	
	.notification .number-notify {
		bottom: 55px;
	}
 }
 @media screen and (max-width: 480px){
	
 }
 @media screen and (max-width: 1028px){
	
 }
</style>
@endsection
